<?php
$page_title = 'Contact — Alpha Invest AI';
include __DIR__ . '/header.php';

$feedback = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    function clean($s) {
        return htmlspecialchars(trim($s), ENT_QUOTES, 'UTF-8');
    }
    $name = isset($_POST['name']) ? clean($_POST['name']) : '';
    $email = isset($_POST['email']) ? clean($_POST['email']) : '';
    $subject = isset($_POST['subject']) ? clean($_POST['subject']) : 'Website Inquiry';
    $message = isset($_POST['message']) ? clean($_POST['message']) : '';

    $errors = [];
    if (strlen($name) < 2) $errors[] = 'Please enter your name.';
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Please enter a valid email.';
    if (strlen($message) < 5) $errors[] = 'Message is too short.';

    if (empty($errors)) {
        $dir = __DIR__ . '/contacts';
        if (!is_dir($dir)) @mkdir($dir, 0755, true);
        $file = $dir . '/contacts.txt';
        $entry = '[' . date('Y-m-d H:i:s') . "] Name: {$name} | Email: {$email} | Subject: {$subject}\nMessage: {$message}\n\n";
        @file_put_contents($file, $entry, FILE_APPEND | LOCK_EX);

        // send email (uses configured mail on host)
        $to = 'info@alphainvestai.com';
        $headers = "From: {$name} <{$email}>\r\n";
        $headers .= "Reply-To: {$email}\r\n";
        $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
        $body = "Alpha Invest AI Website Inquiry\n\nName: {$name}\nEmail: {$email}\nSubject: {$subject}\n\nMessage:\n{$message}\n";
        @mail($to, $subject, $body, $headers);

        $feedback = 'Thank you! Your message has been sent.';
        $name = $email = $subject = $message = '';
    } else {
        $feedback = implode(' ', $errors);
    }
}
?>
<div class="container">
  <section class="card">
    <h1>Contact Us</h1>
    <p class="muted">Suite 400, 123 King Street<br>Brantford, ON N3T 2Y1, Canada<br>Phone: +1 (226) 555-0100<br>Email: info@alphainvestai.com</p>

    <?php if(!empty($feedback)): ?>
      <div style="background:rgba(31,182,255,0.08);padding:10px;border-radius:8px;margin-bottom:12px;color:var(--white)">
        <?php echo $feedback; ?>
      </div>
    <?php endif; ?>

    <form method="post" novalidate>
      <label for="name">Name</label>
      <input id="name" name="name" type="text" value="<?php echo isset($name) ? $name : ''; ?>" required>

      <label for="email" style="margin-top:10px">Email</label>
      <input id="email" name="email" type="email" value="<?php echo isset($email) ? $email : ''; ?>" required>

      <label for="subject" style="margin-top:10px">Subject</label>
      <input id="subject" name="subject" type="text" value="<?php echo isset($subject) ? $subject : 'Website Inquiry'; ?>">

      <label for="message" style="margin-top:10px">Message</label>
      <textarea id="message" name="message" required><?php echo isset($message) ? $message : ''; ?></textarea>

      <div style="margin-top:12px">
        <button class="btn" type="submit">Send Message</button>
      </div>
    </form>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>